/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tools;

import net.ftb.log.Logger;

public class ProcessMonitor
implements Runnable {
    private final Process proc;
    private final Runnable onComplete;
    private volatile boolean complete = false;

    private ProcessMonitor(Process proc, Runnable onComplete) {
        this.proc = proc;
        this.onComplete = onComplete;
    }

    @Override
    public void run() {
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException e) {
            Logger.logError("ProcessMonitor interrupted", e);
        }
        this.complete = true;
        this.onComplete.run();
    }

    public static ProcessMonitor create(Process proc, Runnable onComplete) {
        ProcessMonitor processMonitor = new ProcessMonitor(proc, onComplete);
        Thread monitorThread = new Thread(processMonitor);
        monitorThread.start();
        return processMonitor;
    }

    public void stop() {
        if (this.proc != null) {
            this.proc.destroy();
        }
    }
}

